"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Edit = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _domain = require("../../../../common/types/domain");
var _view = require("./view");
var _translations = require("../translations");
var _config = require("./config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormWrapperComponent = ({
  initialValue,
  customFieldConfiguration,
  isLoading,
  onChange
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      value: initialValue
    }
  });
  const {
    submit,
    isValid: isFormValid
  } = form;
  (0, _react.useEffect)(() => {
    onChange({
      isValid: isFormValid,
      submit
    });
  }, [isFormValid, onChange, submit]);
  const formFieldConfig = (0, _config.getTextFieldConfig)({
    required: customFieldConfiguration.required,
    label: customFieldConfiguration.label
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "value",
    config: formFieldConfig,
    component: _components.TextField,
    componentProps: {
      euiFieldProps: {
        fullWidth: true,
        disabled: isLoading,
        isLoading,
        'data-test-subj': `case-text-custom-field-form-field-${customFieldConfiguration.key}`
      }
    }
  }));
};
FormWrapperComponent.displayName = 'FormWrapper';
const EditComponent = ({
  customField,
  customFieldConfiguration,
  onSubmit,
  isLoading,
  canUpdate
}) => {
  var _customField$value;
  const [isEdit, setIsEdit] = (0, _react.useState)(false);
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {
        value: ''
      }
    })
  });
  const onEdit = () => {
    setIsEdit(true);
  };
  const onCancel = () => {
    setIsEdit(false);
  };
  const onSubmitCustomField = async () => {
    const {
      isValid,
      data
    } = await formState.submit();
    if (isValid) {
      var _customField$key;
      const value = (0, _lodash.isEmpty)(data.value) ? null : data.value;
      onSubmit({
        ...customField,
        key: (_customField$key = customField === null || customField === void 0 ? void 0 : customField.key) !== null && _customField$key !== void 0 ? _customField$key : customFieldConfiguration.key,
        type: _domain.CustomFieldTypes.TEXT,
        value
      });
    }
    setIsEdit(false);
  };
  const initialValue = (_customField$value = customField === null || customField === void 0 ? void 0 : customField.value) !== null && _customField$value !== void 0 ? _customField$value : '';
  const title = customFieldConfiguration.label;
  const isTextFieldValid = formState.isValid;
  const isCustomFieldValueDefined = !(0, _lodash.isEmpty)(customField === null || customField === void 0 ? void 0 : customField.value);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, title))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": `case-text-custom-field-loading-${customFieldConfiguration.key}`
  }), !isLoading && canUpdate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `case-text-custom-field-edit-button-${customFieldConfiguration.key}`,
    "aria-label": (0, _translations.EDIT_CUSTOM_FIELDS_ARIA_LABEL)(title),
    iconType: 'pencil',
    onClick: onEdit
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": `case-text-custom-field-${customFieldConfiguration.key}`,
    direction: "column"
  }, !isCustomFieldValueDefined && !isEdit && /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "no-custom-field-value"
  }, _translations.NO_CUSTOM_FIELD_SET), !isEdit && isCustomFieldValueDefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_view.View, {
    customField: customField
  })), isEdit && canUpdate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FormWrapperComponent, {
    initialValue: initialValue,
    isLoading: isLoading,
    onChange: setFormState,
    customFieldConfiguration: customFieldConfiguration
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": `case-text-custom-field-submit-button-${customFieldConfiguration.key}`,
    fill: true,
    iconType: "save",
    onClick: onSubmitCustomField,
    size: "s",
    disabled: !isTextFieldValid || isLoading
  }, _translations.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `case-text-custom-field-cancel-button-${customFieldConfiguration.key}`,
    iconType: "cross",
    onClick: onCancel,
    size: "s"
  }, _translations.CANCEL)))))));
};
EditComponent.displayName = 'Edit';
const Edit = /*#__PURE__*/_react.default.memo(EditComponent);
exports.Edit = Edit;