"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextFieldConfig = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../../common/constants");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const getTextFieldConfig = ({
  required,
  label
}) => {
  const validators = [];
  if (required) {
    validators.push({
      validator: emptyField((0, _translations.REQUIRED_FIELD)(label))
    });
  }
  return {
    validations: [...validators, {
      validator: ({
        value
      }) => {
        if (value == null) {
          return;
        }
        if (value.length > _constants.MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH) {
          return {
            message: (0, _translations.MAX_LENGTH_ERROR)(label, _constants.MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH)
          };
        }
      }
    }]
  };
};
exports.getTextFieldConfig = getTextFieldConfig;