"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _constants = require("../../../common/constants");
var _domain = require("../../../common/types/domain");
var _schema = require("./schema");
var _utils = require("../configure_cases/utils");
var _use_post_case = require("../../containers/use_post_case");
var _use_post_push_to_service = require("../../containers/use_post_push_to_service");
var _use_create_attachments = require("../../containers/use_create_attachments");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_features = require("../../common/use_cases_features");
var _utils2 = require("../utils");
var _use_available_owners = require("../app/use_available_owners");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_cases_transactions = require("../../common/apm/use_cases_transactions");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialCaseValue = {
  description: '',
  tags: [],
  title: '',
  severity: _domain.CaseSeverity.LOW,
  connectorId: _constants.NONE_CONNECTOR_ID,
  fields: null,
  syncAlerts: true,
  selectedOwner: null,
  assignees: [],
  customFields: {}
};
const FormContext = ({
  afterCaseCreated,
  children,
  onSuccess,
  attachments,
  initialValue
}) => {
  const {
    data: connectors = [],
    isLoading: isLoadingConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    data: {
      customFields: customFieldsConfiguration
    },
    isLoading: isLoadingCaseConfiguration
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const {
    owner,
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isSyncAlertsEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    mutateAsync: postCase
  } = (0, _use_post_case.usePostCase)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    mutateAsync: pushCaseToExternalService
  } = (0, _use_post_push_to_service.usePostPushToService)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useCreateCaseWithAttachmentsTransaction)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const trimUserFormData = userFormData => {
    let formData = {
      ...userFormData,
      title: userFormData.title.trim(),
      description: userFormData.description.trim()
    };
    if (userFormData.category) {
      formData = {
        ...formData,
        category: userFormData.category.trim()
      };
    }
    if (userFormData.tags) {
      formData = {
        ...formData,
        tags: userFormData.tags.map(tag => tag.trim())
      };
    }
    return formData;
  };
  const transformCustomFieldsData = (0, _react.useCallback)(customFields => {
    const transformedCustomFields = [];
    if (!customFields || !customFieldsConfiguration.length) {
      return [];
    }
    for (const [key, value] of Object.entries(customFields)) {
      const configCustomField = customFieldsConfiguration.find(item => item.key === key);
      if (configCustomField) {
        transformedCustomFields.push({
          key: configCustomField.key,
          type: configCustomField.type,
          value: (0, _utils2.convertCustomFieldValue)(value)
        });
      }
    }
    return transformedCustomFields;
  }, [customFieldsConfiguration]);
  const submitCase = (0, _react.useCallback)(async ({
    connectorId: dataConnectorId,
    fields,
    syncAlerts = isSyncAlertsEnabled,
    ...dataWithoutConnectorId
  }, isValid) => {
    if (isValid) {
      var _owner$;
      const {
        selectedOwner,
        customFields,
        ...userFormData
      } = dataWithoutConnectorId;
      const caseConnector = (0, _utils2.getConnectorById)(dataConnectorId, connectors);
      const defaultOwner = (_owner$ = owner[0]) !== null && _owner$ !== void 0 ? _owner$ : availableOwners[0];
      startTransaction({
        appId,
        attachments
      });
      const connectorToUpdate = caseConnector ? (0, _utils.normalizeActionConnector)(caseConnector, fields) : (0, _utils.getNoneConnector)();
      const transformedCustomFields = transformCustomFieldsData(customFields);
      const trimmedData = trimUserFormData(userFormData);
      const theCase = await postCase({
        request: {
          ...trimmedData,
          connector: connectorToUpdate,
          settings: {
            syncAlerts
          },
          owner: selectedOwner !== null && selectedOwner !== void 0 ? selectedOwner : defaultOwner,
          customFields: transformedCustomFields
        }
      });

      // add attachments to the case
      if (theCase && Array.isArray(attachments) && attachments.length > 0) {
        await createAttachments({
          caseId: theCase.id,
          caseOwner: theCase.owner,
          attachments
        });
      }
      if (afterCaseCreated && theCase) {
        await afterCaseCreated(theCase, createAttachments);
      }
      if (theCase !== null && theCase !== void 0 && theCase.id && connectorToUpdate.id !== 'none') {
        await pushCaseToExternalService({
          caseId: theCase.id,
          connector: connectorToUpdate
        });
      }
      if (onSuccess && theCase) {
        onSuccess(theCase);
      }
    }
  }, [isSyncAlertsEnabled, connectors, startTransaction, appId, attachments, postCase, owner, availableOwners, afterCaseCreated, onSuccess, createAttachments, pushCaseToExternalService, transformCustomFieldsData]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      ...initialCaseValue,
      ...initialValue
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitCase,
    serializer: _utils2.getConnectorsFormSerializer,
    deserializer: _utils2.getConnectorsFormDeserializer
  });
  const childrenWithExtraProp = (0, _react.useMemo)(() => children != null ? _react.default.Children.map(children, child => /*#__PURE__*/_react.default.cloneElement(child, {
    connectors,
    isLoadingConnectors,
    customFieldsConfiguration,
    isLoadingCaseConfiguration
  })) : null, [children, connectors, isLoadingConnectors, customFieldsConfiguration, isLoadingCaseConfiguration]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    onKeyDown: e => {
      // It avoids the focus scaping from the flyout when enter is pressed.
      // https://github.com/elastic/kibana/issues/111120
      if (e.key === 'Enter') {
        e.stopPropagation();
      }
    },
    form: form
  }, childrenWithExtraProp);
};
exports.FormContext = FormContext;
FormContext.displayName = 'FormContext';