"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetChoices = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _constants = require("../constants");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetChoices = ({
  http,
  connector,
  fields
}) => {
  var _connector$id;
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.connectorsQueriesKeys.servicenowGetChoices((_connector$id = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id !== void 0 ? _connector$id : '', fields), ({
    signal
  }) => {
    var _connector$id2;
    return (0, _api.getChoices)({
      http,
      signal,
      connectorId: (_connector$id2 = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id2 !== void 0 ? _connector$id2 : '',
      fields
    });
  }, {
    enabled: Boolean(connector),
    staleTime: 60 * 1000,
    // one minute
    onSuccess: res => {
      if (res.status && res.status === 'error') {
        var _res$serviceMessage;
        showErrorToast(new Error(i18n.CHOICES_API_ERROR), {
          title: i18n.CHOICES_API_ERROR,
          toastMessage: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
        });
      }
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.CHOICES_API_ERROR
      });
    }
  });
};
exports.useGetChoices = useGetChoices;