"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIssues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _kibana = require("../../../common/lib/kibana");
var _use_get_issues = require("./use_get_issues");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIssuesComponent = ({
  actionConnector
}) => {
  var _issuesData$data;
  const [query, setQuery] = (0, _react.useState)(null);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isFetching: isLoadingIssues,
    data: issuesData
  } = (0, _use_get_issues.useGetIssues)({
    http,
    actionConnector,
    query
  });
  const issues = (_issuesData$data = issuesData === null || issuesData === void 0 ? void 0 : issuesData.data) !== null && _issuesData$data !== void 0 ? _issuesData$data : [];
  const options = issues.map(issue => ({
    label: issue.title,
    value: issue.key
  }));
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.parent"
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onSearchChange = searchVal => {
      setQuery(searchVal);
    };
    const onChangeComboBox = changedOptions => {
      var _changedOptions$0$val;
      setSelectedOptions(changedOptions);
      field.setValue((_changedOptions$0$val = changedOptions[0].value) !== null && _changedOptions$0$val !== void 0 ? _changedOptions$0$val : '');
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: i18n.PARENT_ISSUE,
      isInvalid: isInvalid,
      error: errorMessage
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      singleSelection: true,
      async: true,
      placeholder: i18n.SEARCH_ISSUES_PLACEHOLDER,
      "aria-label": i18n.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL,
      isLoading: isLoadingIssues,
      isInvalid: isInvalid,
      noSuggestions: !options.length,
      options: options,
      "data-test-subj": "search-parent-issues",
      "data-testid": "search-parent-issues",
      selectedOptions: selectedOptions,
      onChange: onChangeComboBox,
      onSearchChange: onSearchChange
    }));
  });
};
SearchIssuesComponent.displayName = 'SearchIssues';
const SearchIssues = /*#__PURE__*/(0, _react.memo)(SearchIssuesComponent);
exports.SearchIssues = SearchIssues;