"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumnsSelection = useCasesColumnsSelection;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _constants = require("../../../common/constants");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_columns_configuration = require("./use_cases_columns_configuration");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTableColumnsLocalStorageKey = appId => {
  const filteringKey = _constants.LOCAL_STORAGE_KEYS.casesTableColumns;
  return `${appId}.${filteringKey}`;
};
function useCasesColumnsSelection() {
  const {
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const casesColumnsConfig = (0, _use_cases_columns_configuration.useCasesColumnsConfiguration)();
  const [selectedColumns, setSelectedColumns] = (0, _useLocalStorage.default)(getTableColumnsLocalStorageKey(appId));
  const columns = selectedColumns || [];
  return {
    selectedColumns: (0, _utils.mergeSelectedColumnsWithConfiguration)({
      selectedColumns: columns,
      casesColumnsConfig
    }),
    setSelectedColumns
  };
}