"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilterComponent = exports.StatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _domain = require("../../../common/types/domain");
var _multi_select_filter = require("./multi_select_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const caseStatuses = [{
  key: _domain.CaseStatuses.open,
  label: i18n.STATUS_OPEN
}, {
  key: _domain.CaseStatuses['in-progress'],
  label: i18n.STATUS_IN_PROGRESS
}, {
  key: _domain.CaseStatuses.closed,
  label: i18n.STATUS_CLOSED
}];
const StatusFilterComponent = ({
  countClosedCases,
  countInProgressCases,
  countOpenCases,
  hiddenStatuses = [],
  onChange,
  selectedOptionKeys
}) => {
  const stats = (0, _react.useMemo)(() => ({
    [_domain.CaseStatuses.open]: countOpenCases !== null && countOpenCases !== void 0 ? countOpenCases : 0,
    [_domain.CaseStatuses['in-progress']]: countInProgressCases !== null && countInProgressCases !== void 0 ? countInProgressCases : 0,
    [_domain.CaseStatuses.closed]: countClosedCases !== null && countClosedCases !== void 0 ? countClosedCases : 0
  }), [countClosedCases, countInProgressCases, countOpenCases]);
  const options = (0, _react.useMemo)(() => [...caseStatuses].filter(status => !hiddenStatuses.includes(status.key)), [hiddenStatuses]);
  const renderOption = option => {
    const selectedStatus = option.key;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: 'center',
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_status.Status, {
      status: selectedStatus
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, ` (${stats[selectedStatus]})`));
  };
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.STATUS,
    id: 'status',
    onChange: onChange,
    options: options,
    renderOption: renderOption,
    selectedOptionKeys: selectedOptionKeys
  });
};
exports.StatusFilterComponent = StatusFilterComponent;
StatusFilterComponent.displayName = 'StatusFilterComponent';
const StatusFilter = /*#__PURE__*/_react.default.memo(StatusFilterComponent);
exports.StatusFilter = StatusFilter;