"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionFilterComponent = exports.SolutionFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _multi_select_filter = require("./multi_select_filter");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidSolution = solution => Object.keys(_constants.OWNER_INFO).includes(solution);
const mapToReadableSolutionName = solution => {
  if (isValidSolution(solution)) {
    return _constants.OWNER_INFO[solution];
  }
  return {
    id: solution,
    label: solution,
    iconType: ''
  };
};
const SolutionFilterComponent = ({
  onChange,
  selectedOptionKeys,
  availableSolutions
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const hasOwner = Boolean(owner.length);
  const options = (0, _multi_select_filter.mapToMultiSelectOption)(hasOwner ? owner : availableSolutions);
  const solutions = availableSolutions.map(solution => mapToReadableSolutionName(solution));
  const renderOption = option => {
    const solution = solutions.find(solutionData => solutionData.id === option.label);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: solution.iconType,
      title: solution.label
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, solution.label));
  };
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.SOLUTION,
    id: 'owner',
    onChange: onChange,
    options: options,
    renderOption: renderOption,
    selectedOptionKeys: selectedOptionKeys
  });
};
exports.SolutionFilterComponent = SolutionFilterComponent;
SolutionFilterComponent.displayName = 'SolutionFilterComponent';
const SolutionFilter = /*#__PURE__*/_react.default.memo(SolutionFilterComponent);
exports.SolutionFilter = SolutionFilter;
SolutionFilter.displayName = 'SolutionFilter';