"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_delete_cases = require("../../../containers/use_delete_cases");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeleteActionTitle = totalCases => totalCases > 1 ? i18n.BULK_ACTION_DELETE_LABEL : i18n.DELETE_ACTION_LABEL;
const useDeleteAction = ({
  onAction,
  onActionSuccess,
  isDisabled
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [caseToBeDeleted, setCaseToBeDeleted] = (0, _react.useState)([]);
  const canDelete = permissions.delete;
  const isActionDisabled = isDisabled || !canDelete;
  const onCloseModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const openModal = (0, _react.useCallback)(selectedCases => {
    onAction();
    setIsModalVisible(true);
    setCaseToBeDeleted(selectedCases);
  }, [onAction]);
  const {
    mutate: deleteCases
  } = (0, _use_delete_cases.useDeleteCases)();
  const onConfirmDeletion = (0, _react.useCallback)(() => {
    onCloseModal();
    deleteCases({
      caseIds: caseToBeDeleted.map(({
        id
      }) => id),
      successToasterTitle: i18n.DELETED_CASES(caseToBeDeleted.length)
    }, {
      onSuccess: onActionSuccess
    });
  }, [deleteCases, onActionSuccess, onCloseModal, caseToBeDeleted]);
  const color = isActionDisabled ? euiTheme.euiTheme.colors.disabled : 'danger';
  const getAction = selectedCases => {
    return {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: color
      }, getDeleteActionTitle(selectedCases.length)),
      onClick: () => openModal(selectedCases),
      disabled: isActionDisabled,
      'data-test-subj': 'cases-bulk-action-delete',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        size: "m",
        color: color
      }),
      key: 'cases-bulk-action-delete'
    };
  };
  return {
    getAction,
    isModalVisible,
    onConfirmDeletion,
    onCloseModal,
    canDelete
  };
};
exports.useDeleteAction = useDeleteAction;