"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimlaneFieldsRt = exports.SwimlaneConnectorType = exports.ServiceNowSIRFieldsRt = exports.ServiceNowITSMFieldsRt = exports.ResilientFieldsRt = exports.JiraFieldsRt = exports.ConnectorTypes = exports.ConnectorTypeFieldsRt = exports.ConnectorMappingsRt = exports.ConnectorMappingsAttributesRt = exports.CaseUserActionConnectorRt = exports.CaseConnectorRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConnectorTypes;
exports.ConnectorTypes = ConnectorTypes;
(function (ConnectorTypes) {
  ConnectorTypes["casesWebhook"] = ".cases-webhook";
  ConnectorTypes["jira"] = ".jira";
  ConnectorTypes["none"] = ".none";
  ConnectorTypes["resilient"] = ".resilient";
  ConnectorTypes["serviceNowITSM"] = ".servicenow";
  ConnectorTypes["serviceNowSIR"] = ".servicenow-sir";
  ConnectorTypes["swimlane"] = ".swimlane";
})(ConnectorTypes || (exports.ConnectorTypes = ConnectorTypes = {}));
const ConnectorCasesWebhookTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.casesWebhook),
  fields: rt.null
});

/**
 * Jira
 */

const JiraFieldsRt = rt.strict({
  issueType: rt.union([rt.string, rt.null]),
  priority: rt.union([rt.string, rt.null]),
  parent: rt.union([rt.string, rt.null])
});
exports.JiraFieldsRt = JiraFieldsRt;
const ConnectorJiraTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.jira),
  fields: rt.union([JiraFieldsRt, rt.null])
});

/**
 * Resilient
 */

const ResilientFieldsRt = rt.strict({
  incidentTypes: rt.union([rt.array(rt.string), rt.null]),
  severityCode: rt.union([rt.string, rt.null])
});
exports.ResilientFieldsRt = ResilientFieldsRt;
const ConnectorResilientTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.resilient),
  fields: rt.union([ResilientFieldsRt, rt.null])
});

/**
 * ServiceNow
 */

const ServiceNowITSMFieldsRt = rt.strict({
  impact: rt.union([rt.string, rt.null]),
  severity: rt.union([rt.string, rt.null]),
  urgency: rt.union([rt.string, rt.null]),
  category: rt.union([rt.string, rt.null]),
  subcategory: rt.union([rt.string, rt.null])
});
exports.ServiceNowITSMFieldsRt = ServiceNowITSMFieldsRt;
const ConnectorServiceNowITSMTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowITSM),
  fields: rt.union([ServiceNowITSMFieldsRt, rt.null])
});
const ServiceNowSIRFieldsRt = rt.strict({
  category: rt.union([rt.string, rt.null]),
  destIp: rt.union([rt.boolean, rt.null]),
  malwareHash: rt.union([rt.boolean, rt.null]),
  malwareUrl: rt.union([rt.boolean, rt.null]),
  priority: rt.union([rt.string, rt.null]),
  sourceIp: rt.union([rt.boolean, rt.null]),
  subcategory: rt.union([rt.string, rt.null])
});
exports.ServiceNowSIRFieldsRt = ServiceNowSIRFieldsRt;
const ConnectorServiceNowSIRTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowSIR),
  fields: rt.union([ServiceNowSIRFieldsRt, rt.null])
});

/**
 * Swimlane
 */

const SwimlaneFieldsRt = rt.strict({
  caseId: rt.union([rt.string, rt.null])
});
exports.SwimlaneFieldsRt = SwimlaneFieldsRt;
let SwimlaneConnectorType;
exports.SwimlaneConnectorType = SwimlaneConnectorType;
(function (SwimlaneConnectorType) {
  SwimlaneConnectorType["All"] = "all";
  SwimlaneConnectorType["Alerts"] = "alerts";
  SwimlaneConnectorType["Cases"] = "cases";
})(SwimlaneConnectorType || (exports.SwimlaneConnectorType = SwimlaneConnectorType = {}));
const ConnectorSwimlaneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.swimlane),
  fields: rt.union([SwimlaneFieldsRt, rt.null])
});

/**
 * None connector
 */

const ConnectorNoneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.none),
  fields: rt.null
});
const ConnectorTypeFieldsRt = rt.union([ConnectorCasesWebhookTypeFieldsRt, ConnectorJiraTypeFieldsRt, ConnectorNoneTypeFieldsRt, ConnectorResilientTypeFieldsRt, ConnectorServiceNowITSMTypeFieldsRt, ConnectorServiceNowSIRTypeFieldsRt, ConnectorSwimlaneTypeFieldsRt]);

/**
 * This type represents the connector's format when it is encoded within a user action.
 */
exports.ConnectorTypeFieldsRt = ConnectorTypeFieldsRt;
const CaseUserActionConnectorRt = rt.union([rt.intersection([ConnectorCasesWebhookTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorJiraTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorNoneTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorResilientTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowITSMTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowSIRTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorSwimlaneTypeFieldsRt, rt.strict({
  name: rt.string
})])]);
exports.CaseUserActionConnectorRt = CaseUserActionConnectorRt;
const CaseConnectorRt = rt.intersection([rt.strict({
  id: rt.string
}), CaseUserActionConnectorRt]);

/**
 * Mappings
 */
exports.CaseConnectorRt = CaseConnectorRt;
const ConnectorMappingActionTypeRt = rt.union([rt.literal('append'), rt.literal('nothing'), rt.literal('overwrite')]);
const ConnectorMappingSourceRt = rt.union([rt.literal('title'), rt.literal('description'), rt.literal('comments'), rt.literal('tags')]);
const ConnectorMappingTargetRt = rt.union([rt.string, rt.literal('not_mapped')]);
const ConnectorMappingRt = rt.strict({
  action_type: ConnectorMappingActionTypeRt,
  source: ConnectorMappingSourceRt,
  target: ConnectorMappingTargetRt
});
const ConnectorMappingsRt = rt.array(ConnectorMappingRt);
exports.ConnectorMappingsRt = ConnectorMappingsRt;
const ConnectorMappingsAttributesRt = rt.strict({
  mappings: ConnectorMappingsRt,
  owner: rt.string
});
exports.ConnectorMappingsAttributesRt = ConnectorMappingsAttributesRt;