"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFullscreenPresentationHelper = void 0;
var _react = require("react");
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _services = require("../../../services");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullscreenClass = 'canvas-isFullscreen';
const useFullscreenPresentationHelper = () => {
  const {
    isFullscreen
  } = (0, _react.useContext)(_.WorkpadRoutingContext);
  const {
    setFullscreen
  } = (0, _services.usePlatformService)();
  (0, _react.useEffect)(() => {
    const body = document.querySelector('body');
    const bodyClassList = body.classList;
    const hasFullscreenClass = bodyClassList.contains(fullscreenClass);
    if (isFullscreen && !hasFullscreenClass) {
      setFullscreen(false);
      bodyClassList.add(fullscreenClass);
    } else if (!isFullscreen && hasFullscreenClass) {
      bodyClassList.remove(fullscreenClass);
      setFullscreen(true);
    }
  }, [isFullscreen, setFullscreen]);

  // Remove fullscreen when component unmounts
  (0, _useEffectOnce.default)(() => () => {
    var _document$querySelect;
    setFullscreen(true);
    (_document$querySelect = document.querySelector('body')) === null || _document$querySelect === void 0 ? void 0 : _document$querySelect.classList.remove(fullscreenClass);
  });
};
exports.useFullscreenPresentationHelper = useFullscreenPresentationHelper;