"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.destroyRegistries = destroyRegistries;
exports.initRegistries = initRegistries;
exports.populateRegistries = populateRegistries;
exports.registries = void 0;
var _interpreter = require("@kbn/interpreter");
var _elements_registry = require("./lib/elements_registry");
var _templates_registry = require("./lib/templates_registry");
var _tags_registry = require("./lib/tags_registry");
var _transitions_registry = require("./lib/transitions_registry");
var _expression_types = require("./expression_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

// @ts-expect-error untyped local

let registries = {};
exports.registries = registries;
function initRegistries() {
  (0, _interpreter.addRegistries)(registries, {
    elements: _elements_registry.elementsRegistry,
    transformUIs: _expression_types.transformRegistry,
    datasourceUIs: _expression_types.datasourceRegistry,
    modelUIs: _expression_types.modelRegistry,
    viewUIs: _expression_types.viewRegistry,
    argumentUIs: _expression_types.argTypeRegistry,
    templates: _templates_registry.templatesRegistry,
    tagUIs: _tags_registry.tagsRegistry,
    transitions: _transitions_registry.transitionsRegistry
  });
}
async function populateRegistries(setupRegistries) {
  // Our setup registries could contain definitions or a function that would
  // return a promise of definitions.
  // We need to call all the fns and then wait for all of the promises to be resolved
  const resolvedRegistries = {};
  const promises = Object.entries(setupRegistries).map(async ([key, specs]) => {
    const resolved = await (await Promise.all(specs.map(fn => typeof fn === 'function' ? fn() : fn))).flat();
    resolvedRegistries[key] = resolved;
  });

  // Now, wait for all of the promise registry promises to resolve and our resolved registry will be ready
  // and we can proceeed
  await Promise.all(promises);
  (0, _interpreter.register)(registries, resolvedRegistries);
}
function destroyRegistries() {
  exports.registries = registries = {};
}