"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _filter = require("../../lib/filter");
var _sidebar = require("../../state/actions/sidebar");
var _sidebar2 = require("../../state/selectors/sidebar");
var _hooks = require("./hooks");
var _workpad_filters = require("./workpad_filters.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadFilters = ({
  element
}) => {
  const groupFiltersByField = (0, _reactRedux.useSelector)(state => (0, _sidebar2.getGroupFiltersByOption)(state));
  const dispatch = (0, _reactRedux.useDispatch)();
  const onGroupByChange = (0, _react.useCallback)(groupByOption => {
    dispatch((0, _sidebar.setGroupFiltersByOption)(groupByOption));
  }, [dispatch]);
  const filterExprs = element ? (0, _filter.getFiltersExprsFromExpression)(element.expression) : [];
  const canvasFilters = (0, _hooks.useCanvasFilters)(filterExprs);
  const filtersGroups = groupFiltersByField ? (0, _filter.groupFiltersBy)(canvasFilters, groupFiltersByField) : [];
  return /*#__PURE__*/_react.default.createElement(_workpad_filters.WorkpadFilters, {
    filtersGroups: filtersGroups,
    onGroupByChange: onGroupByChange,
    groupFiltersByField: groupFiltersByField
  });
};
exports.WorkpadFilters = WorkpadFilters;