"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withUnconnectedElementsLoadedTelemetry = exports.withElementsLoadedTelemetry = exports.WorkpadLoadedWithErrorsMetric = exports.WorkpadLoadedMetric = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _ui_metric = require("../../lib/ui_metric");
var _workpad = require("../../state/selectors/workpad");
var _resolved_args = require("../../state/selectors/resolved_args");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadLoadedMetric = 'workpad-loaded';
exports.WorkpadLoadedMetric = WorkpadLoadedMetric;
const WorkpadLoadedWithErrorsMetric = 'workpad-loaded-with-errors';
exports.WorkpadLoadedWithErrorsMetric = WorkpadLoadedWithErrorsMetric;
// TODO: Build out full workpad types
/**
  Individual Page of a Workpad
 */
/**
 A canvas workpad object
 */
/**
 Collection of resolved elements
 */
function areAllElementsInResolvedArgs(workpad, resolvedArgs) {
  const resolvedArgsElements = Object.keys(resolvedArgs);
  const workpadElements = workpad.pages.reduce((reduction, page) => {
    return [...reduction, ...page.elements.map(element => element.id)];
  }, []);
  return workpadElements.every(element => resolvedArgsElements.includes(element));
}
const withUnconnectedElementsLoadedTelemetry = (Component, trackMetric = _ui_metric.trackCanvasUiMetric) => function ElementsLoadedTelemetry(props) {
  const {
    workpad
  } = props;
  const [currentWorkpadId, setWorkpadId] = (0, _react.useState)(undefined);
  const [hasReported, setHasReported] = (0, _react.useState)(false);
  const telemetryElementCounts = (0, _reactRedux.useSelector)(state => (0, _workpad.getElementCounts)(state), _reactRedux.shallowEqual);
  const telemetryResolvedArgs = (0, _reactRedux.useSelector)(state => (0, _resolved_args.getArgs)(state), _reactFastCompare.default);
  const resolvedArgsAreForWorkpad = areAllElementsInResolvedArgs(workpad, telemetryResolvedArgs);
  const {
    error,
    pending
  } = telemetryElementCounts;
  const resolved = resolvedArgsAreForWorkpad && pending === 0;
  (0, _react.useEffect)(() => {
    if (workpad.id !== currentWorkpadId) {
      const workpadElementCount = workpad.pages.reduce((reduction, page) => reduction + page.elements.length, 0);
      setWorkpadId(workpad.id);
      setHasReported(workpadElementCount === 0 || resolved);
    } else if (!hasReported && resolved) {
      if (error > 0) {
        trackMetric(_ui_metric.METRIC_TYPE.LOADED, [WorkpadLoadedMetric, WorkpadLoadedWithErrorsMetric]);
      } else {
        trackMetric(_ui_metric.METRIC_TYPE.LOADED, WorkpadLoadedMetric);
      }
      setHasReported(true);
    }
  }, [currentWorkpadId, hasReported, error, workpad.id, resolved, workpad.pages]);
  return /*#__PURE__*/_react.default.createElement(Component, props);
};
exports.withUnconnectedElementsLoadedTelemetry = withUnconnectedElementsLoadedTelemetry;
const withElementsLoadedTelemetry = Component => withUnconnectedElementsLoadedTelemetry(Component);
exports.withElementsLoadedTelemetry = withElementsLoadedTelemetry;