"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _general_config = require("./general_config");
var _filter_config = require("./filter_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getTitle: () => _i18n.i18n.translate('xpack.canvas.globalConfig.title', {
    defaultMessage: 'Workpad settings'
  }),
  getGeneralLabel: () => _i18n.i18n.translate('xpack.canvas.globalConfig.general', {
    defaultMessage: 'General'
  }),
  getFilterLabel: () => _i18n.i18n.translate('xpack.canvas.globalConfig.filter', {
    defaultMessage: 'Filter'
  })
};
const GlobalConfig = () => {
  const tabs = [{
    id: 'general',
    name: strings.getGeneralLabel(),
    content: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasSidebar__pop"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_general_config.GeneralConfig, null))
  }, {
    id: 'filter',
    name: strings.getFilterLabel(),
    content: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasSidebar__pop"
    }, /*#__PURE__*/_react.default.createElement(_filter_config.FilterConfig, null))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__sidebarHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, strings.getTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    size: "s"
  }));
};
exports.GlobalConfig = GlobalConfig;