"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapePreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _public = require("@kbn/expression-shape-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getViewBox(defaultWidth, defaultViewBox) {
  const {
    minX,
    minY,
    width,
    height
  } = defaultViewBox;
  return {
    minX: minX - defaultWidth / 2,
    minY: minY - defaultWidth / 2,
    width: width + defaultWidth,
    height: height + defaultWidth
  };
}
const ShapePreview = ({
  shape
}) => {
  const [shapeData, setShapeData] = (0, _react.useState)((0, _public.getDefaultShapeData)());
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setShapeData(node.getData());
    }
  }, []);
  if (!shape) return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasShapePreview"
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasShapePreview"
  }, /*#__PURE__*/_react.default.createElement(_public.ShapeDrawerComponent, {
    ref: shapeRef,
    shapeType: shape,
    shapeAttributes: {
      fill: 'none',
      stroke: 'black',
      viewBox: getViewBox(5, shapeData.viewBox)
    }
  }));
};
exports.ShapePreview = ShapePreview;
ShapePreview.propTypes = {
  shape: _propTypes.default.string
};