"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoutingLink = exports.RoutingButtonIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
const isTargetBlank = event => {
  const target = event.target.getAttribute('target');
  return target && target !== '_self';
};
const RoutingLink = ({
  to,
  ...rest
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const onClick = (0, _react.useCallback)(event => {
    if (event.defaultPrevented) {
      return;
    }

    // Let the browser handle links that open new tabs/windows
    if (isModifiedEvent(event) || !isLeftClickEvent(event) || isTargetBlank(event)) {
      return;
    }

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();

    // Push the route to the history.
    history.push(to);
  }, [history, to]);

  // Generate the correct link href (with basename accounted for)
  const href = history.createHref({
    pathname: to
  });
  const props = {
    ...rest,
    href,
    onClick
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, props);
};
exports.RoutingLink = RoutingLink;
const RoutingButtonIcon = ({
  to,
  ...rest
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const onClick = (0, _react.useCallback)(event => {
    if (event.defaultPrevented) {
      return;
    }

    // Let the browser handle links that open new tabs/windows
    if (isModifiedEvent(event) || !isLeftClickEvent(event) || isTargetBlank(event)) {
      return;
    }

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();

    // Push the route to the history.
    history.push(to);
  }, [history, to]);

  // Generate the correct link href (with basename accounted for)
  const href = history.createHref({
    pathname: to
  });
  const props = {
    ...rest,
    href,
    onClick
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, props);
};
exports.RoutingButtonIcon = RoutingButtonIcon;