"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadTableTools = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _app = require("../../../state/selectors/app");
var _hooks = require("../hooks");
var _hooks2 = require("../../hooks");
var _workpad_table_tools = require("./workpad_table_tools.component");
var _my_workpads = require("./my_workpads");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadTableTools = ({
  selectedWorkpadIds
}) => {
  const deleteWorkpads = (0, _hooks.useDeleteWorkpads)();
  const downloadWorkpad = (0, _hooks2.useDownloadWorkpad)();
  const context = (0, _react.useContext)(_my_workpads.WorkpadsContext);
  const {
    canUserWrite
  } = (0, _reactRedux.useSelector)(state => ({
    canUserWrite: (0, _app.canUserWrite)(state)
  }));
  if (context === null || selectedWorkpadIds.length <= 0) {
    return null;
  }
  const {
    workpads,
    setWorkpads
  } = context;
  const onExport = () => selectedWorkpadIds.map(id => downloadWorkpad(id));
  const onDelete = async () => {
    const {
      removedIds
    } = await deleteWorkpads(selectedWorkpadIds);
    setWorkpads(workpads.filter(workpad => !removedIds.includes(workpad.id)));
  };
  return /*#__PURE__*/_react.default.createElement(_workpad_table_tools.WorkpadTableTools, {
    workpads,
    selectedWorkpadIds,
    canUserWrite,
    onDeleteWorkpads: onDelete,
    onExportWorkpads: onExport
  });
};
exports.WorkpadTableTools = WorkpadTableTools;