"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Home = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _public = require("@kbn/presentation-util-plugin/public");
var _workpad_create = require("./workpad_create");
var _workpad_templates = require("./workpad_templates");
var _my_workpads = require("./my_workpads");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadTemplates = (0, _public.withSuspense)(_workpad_templates.LazyWorkpadTemplates);
const MyWorkpads = (0, _public.withSuspense)(_my_workpads.LazyMyWorkpads);
const Home = ({
  activeTab = 'workpads'
}) => {
  const [tab, setTab] = (0, _react.useState)(activeTab);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    pageHeader: {
      pageTitle: 'Canvas',
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_workpad_create.WorkpadCreate, null)],
      tabs: [{
        label: strings.getMyWorkpadsTabLabel(),
        id: 'myWorkpads',
        'data-test-subj': 'workpadListing',
        isSelected: tab === 'workpads',
        onClick: () => setTab('workpads')
      }, {
        label: strings.getWorkpadTemplatesTabLabel(),
        id: 'workpadTemplates',
        'data-test-subj': 'workpadTemplates',
        isSelected: tab === 'templates',
        onClick: () => setTab('templates')
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, tab === 'workpads' ? /*#__PURE__*/_react.default.createElement(MyWorkpads, null) : /*#__PURE__*/_react.default.createElement(WorkpadTemplates, null)));
};
exports.Home = Home;
const strings = {
  getMyWorkpadsTabLabel: () => _i18n.i18n.translate('xpack.canvas.home.myWorkpadsTabLabel', {
    defaultMessage: 'My workpads'
  }),
  getWorkpadTemplatesTabLabel: () => _i18n.i18n.translate('xpack.canvas.home.workpadTemplatesTabLabel', {
    defaultMessage: 'Templates',
    description: 'The label for the tab that displays a list of designed workpad templates.'
  })
};