"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESDataViewSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _services = require("../../services");
var _es_data_view_select = require("./es_data_view_select.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESDataViewSelect = props => {
  const {
    value,
    onChange
  } = props;
  const [dataViews, setDataViews] = (0, _react.useState)([]);
  const [loading, setLoading] = (0, _react.useState)(true);
  const mounted = (0, _react.useRef)(true);
  const {
    getDataViews
  } = (0, _services.useDataViewsService)();
  (0, _useEffectOnce.default)(() => {
    getDataViews().then(newDataViews => {
      if (!mounted.current) {
        return;
      }
      if (!newDataViews) {
        newDataViews = [];
      }
      setLoading(false);
      setDataViews((0, _lodash.sortBy)(newDataViews, ({
        name,
        title
      }) => {
        return name || title || '';
      }));
      if (!value && newDataViews.length) {
        onChange(newDataViews[0].title);
      }
    });
    return () => {
      mounted.current = false;
    };
  });
  return /*#__PURE__*/_react.default.createElement(_es_data_view_select.ESDataViewSelect, (0, _extends2.default)({}, props, {
    dataViews: dataViews,
    loading: loading
  }));
};
exports.ESDataViewSelect = ESDataViewSelect;