"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFlyoutPortal = exports.AddEmbeddablePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactRedux = require("react-redux");
var _embeddable_dataurl = require("../../../common/lib/embeddable_dataurl");
var _flyout = require("./flyout.component");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _embeddable = require("../../../canvas_plugin_src/expression_types/embeddable");
var _services = require("../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const allowedEmbeddables = {
  [_embeddable.EmbeddableTypes.map]: id => {
    return `savedMap id="${id}" | render`;
  },
  [_embeddable.EmbeddableTypes.lens]: id => {
    return `savedLens id="${id}" | render`;
  },
  [_embeddable.EmbeddableTypes.visualization]: id => {
    return `savedVisualization id="${id}" | render`;
  }
  /*
  [EmbeddableTypes.search]: (id: string) => {
    return `filters | savedSearch id="${id}" | render`;
  },*/
};

const EmbeddableFlyoutPortal = props => {
  const el = (0, _react.useMemo)(() => document.createElement('div'), []);
  (0, _react.useEffect)(() => {
    let body = document.querySelector('body');
    if (body && el) {
      body.appendChild(el);
    }
    return () => {
      body = document.querySelector('body');
      if (body && el) {
        body.removeChild(el);
      }
    };
  }, [el]);
  if (!el) {
    return null;
  }
  return /*#__PURE__*/(0, _reactDom.createPortal)( /*#__PURE__*/_react.default.createElement(_flyout.AddEmbeddableFlyout, (0, _extends2.default)({}, props, {
    availableEmbeddables: Object.keys(allowedEmbeddables)
  })), el);
};
exports.EmbeddableFlyoutPortal = EmbeddableFlyoutPortal;
const AddEmbeddablePanel = ({
  availableEmbeddables,
  ...restProps
}) => {
  const labsService = (0, _services.useLabsService)();
  const isByValueEnabled = labsService.isProjectEnabled('labs:canvas:byValueEmbeddable');
  const dispatch = (0, _reactRedux.useDispatch)();
  const pageId = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedPage)(state));
  const addEmbeddable = (0, _react.useCallback)((selectedPageId, partialElement) => dispatch((0, _elements.addElement)(selectedPageId, partialElement)), [dispatch]);
  const onSelect = (0, _react.useCallback)((id, type) => {
    const partialElement = {
      expression: `markdown "Could not find embeddable for type ${type}" | render`
    };

    // If by-value is enabled, we'll handle both by-reference and by-value embeddables
    // with the new generic `embeddable` function.
    // Otherwise we fallback to the embeddable type specific expressions.
    if (isByValueEnabled) {
      const config = (0, _embeddable_dataurl.encode)({
        savedObjectId: id
      });
      partialElement.expression = `embeddable config="${config}" 
  type="${type}" 
| render`;
    } else if (allowedEmbeddables[type]) {
      partialElement.expression = allowedEmbeddables[type](id);
    }
    addEmbeddable(pageId, partialElement);
    restProps.onClose();
  }, [addEmbeddable, pageId, restProps, isByValueEnabled]);
  return /*#__PURE__*/_react.default.createElement(EmbeddableFlyoutPortal, (0, _extends2.default)({}, restProps, {
    availableEmbeddables: availableEmbeddables || [],
    onSelect: onSelect,
    isByValueEnabled: isByValueEnabled
  }));
};
exports.AddEmbeddablePanel = AddEmbeddablePanel;