"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Banner = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
require("./banner.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Banner = ({
  bannerConfig
}) => {
  const {
    textContent,
    textColor,
    backgroundColor
  } = bannerConfig;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnUserBanner__container",
    style: {
      backgroundColor,
      color: textColor
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    "data-test-subj": "bannerInnerWrapper"
  }, /*#__PURE__*/_react.default.createElement(_public.Markdown, {
    markdown: textContent,
    openLinksInNewTab: true
  })));
};
exports.Banner = Banner;