"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _ping = require("./ping");
var _sample_assets = require("./sample_assets");
var _assets = require("./assets");
var _hosts = require("./assets/hosts");
var _services = require("./assets/services");
var _containers = require("./assets/containers");
var _pods = require("./assets/pods");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupRoutes({
  router,
  assetClient
}) {
  (0, _ping.pingRoute)({
    router,
    assetClient
  });
  (0, _sample_assets.sampleAssetsRoutes)({
    router,
    assetClient
  });
  (0, _assets.assetsRoutes)({
    router,
    assetClient
  });
  (0, _hosts.hostsRoutes)({
    router,
    assetClient
  });
  (0, _services.servicesRoutes)({
    router,
    assetClient
  });
  (0, _containers.containersRoutes)({
    router,
    assetClient
  });
  (0, _pods.podsRoutes)({
    router,
    assetClient
  });
}