"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetsRoutes = assetsRoutes;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _types_api = require("../../../common/types_api");
var _debug_log = require("../../../common/debug_log");
var routePaths = _interopRequireWildcard(require("../../../common/constants_routes"));
var _utils = require("../utils");
var _validation_error = require("../../lib/validators/validation_error");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function assetsRoutes({
  router,
  assetClient
}) {
  const validate = (0, _ioTsUtils.createRouteValidationFunction)(_types_api.getAssetsQueryOptionsRT);
  router.get({
    path: routePaths.GET_ASSETS,
    validate: {
      query: (q, res) => {
        const [invalidResponse, validatedFilters] = (0, _utils.validateStringAssetFilters)(q, res);
        if (invalidResponse) {
          return invalidResponse;
        }
        if (validatedFilters) {
          q.filters = validatedFilters;
        }
        return validate(q, res);
      }
    }
  }, async (context, req, res) => {
    const {
      from = 'now-24h',
      to = 'now',
      filters
    } = req.query || {};
    const {
      elasticsearchClient,
      savedObjectsClient
    } = await (0, _utils.getClientsFromContext)(context);
    try {
      const response = await assetClient.getAssets({
        from,
        to,
        filters,
        elasticsearchClient,
        savedObjectsClient
      });
      return res.ok({
        body: response
      });
    } catch (error) {
      (0, _debug_log.debug)('Error while looking up asset records', error);
      if (error instanceof _validation_error.AssetsValidationError) {
        return res.customError({
          statusCode: error.statusCode,
          body: {
            message: `Error while looking up asset records - ${error.message}`
          }
        });
      }
      return res.customError({
        statusCode: 500,
        body: {
          message: 'Error while looking up asset records - ' + `${error}`
        }
      });
    }
  });
}