"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.downstreamDependenciesRouteRt = void 0;
exports.getAssistantDownstreamDependencies = getAssistantDownstreamDependencies;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var t = _interopRequireWildcard(require("io-ts"));
var _server = require("@kbn/observability-plugin/server");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _get_destination_map = require("../../../lib/connections/get_connection_stats/get_destination_map");
var _connections = require("../../../../common/connections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const downstreamDependenciesRouteRt = t.intersection([t.type({
  'service.name': t.string,
  start: t.string,
  end: t.string
}), t.partial({
  'service.environment': t.string
})]);
exports.downstreamDependenciesRouteRt = downstreamDependenciesRouteRt;
async function getAssistantDownstreamDependencies({
  arguments: args,
  apmEventClient
}) {
  var _datemath$parse, _datemath$parse2, _args$serviceEnviron;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const map = await (0, _get_destination_map.getDestinationMap)({
    start,
    end,
    apmEventClient,
    filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, args['service.name']), ...(0, _environment_query.environmentQuery)((_args$serviceEnviron = args['service.environment']) !== null && _args$serviceEnviron !== void 0 ? _args$serviceEnviron : _environment_filter_values.ENVIRONMENT_ALL.value)]
  });
  const items = [];
  for (const [_, node] of map) {
    if (node.type === _connections.NodeType.service) {
      items.push({
        'service.name': node.serviceName,
        // this should be set, as it's a downstream dependency, and there should be a connection
        'span.destination.service.resource': node.dependencyName
      });
    } else {
      items.push({
        'span.destination.service.resource': node.dependencyName,
        'span.type': node.spanType,
        'span.subtype': node.spanSubtype
      });
    }
  }
  return items;
}