"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgents = getAgents;
var _agent_name = require("../../../common/agent_name");
var _get_agent_url_repository = require("./get_agent_url_repository");
var _get_agents_items = require("./get_agents_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOtelAgentVersion = item => {
  // Auto version should take precedence over sdk version
  return item.agentTelemetryAutoVersion.length > 0 ? item.agentTelemetryAutoVersion : item.agentVersion;
};
async function getAgents({
  environment,
  serviceName,
  agentLanguage,
  kuery,
  apmEventClient,
  start,
  end,
  randomSampler
}) {
  const items = await (0, _get_agents_items.getAgentsItems)({
    environment,
    serviceName,
    agentLanguage,
    kuery,
    apmEventClient,
    start,
    end,
    randomSampler
  });
  return {
    items: items.map(item => {
      const agentDocsPageUrl = (0, _get_agent_url_repository.getAgentDocsPageUrl)(item.agentName);
      if ((0, _agent_name.isOpenTelemetryAgentName)(item.agentName)) {
        return {
          ...item,
          agentVersion: getOtelAgentVersion(item),
          agentDocsPageUrl
        };
      }
      return {
        ...item,
        agentDocsPageUrl
      };
    })
  };
}