"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationTable = AgentConfigurationTable;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentConfigurationTable({
  variables,
  data
}) {
  if (!variables) return null;
  const columns = [{
    field: 'setting',
    name: _i18n.i18n.translate('xpack.apm.tutorial.agent.column.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.apm.tutorial.agent.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "accent"
    }, value)
  }];
  const items = Object.keys(variables).map(k => ({
    setting: variables[k],
    value: (0, _lodash.get)(data, k) // TODO do we want default values?
  }));

  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns
  });
}