"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMLocatorPayloadValidator = void 0;
exports.getPathForServiceDetail = getPathForServiceDetail;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _environment_rt = require("../../common/environment_rt");
var _apm_route_config = require("../components/routing/apm_route_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APMLocatorPayloadValidator = t.union([t.type({
  serviceName: t.undefined
}), t.intersection([t.type({
  serviceName: t.string
}), t.type({
  dashboardId: t.string
}), t.type({
  query: _environment_rt.environmentRt
})]), t.intersection([t.type({
  serviceName: t.string
}), t.partial({
  dashboardId: t.undefined
}), t.partial({
  serviceOverviewTab: t.keyof({
    traces: null,
    metrics: null,
    logs: null,
    errors: null
  })
}), t.type({
  query: _environment_rt.environmentRt
})])]);
exports.APMLocatorPayloadValidator = APMLocatorPayloadValidator;
function getPathForServiceDetail(payload, {
  from,
  to,
  isComparisonEnabledByDefault,
  defaultEnvironment
}) {
  const decodedPayload = APMLocatorPayloadValidator.decode(payload);
  if (!(0, _Either.isRight)(decodedPayload)) {
    throw new Error(_PathReporter.PathReporter.report(decodedPayload).join('\n'));
  }
  const defaultQueryParams = {
    kuery: '',
    serviceGroup: '',
    comparisonEnabled: isComparisonEnabledByDefault,
    rangeFrom: from,
    rangeTo: to,
    environment: defaultEnvironment
  };
  if (!payload.serviceName) {
    return _apm_route_config.apmRouter.link('/services', {
      query: defaultQueryParams
    });
  }
  let path;
  if (payload.dashboardId !== undefined) {
    const apmPath = '/services/{serviceName}/dashboards';
    path = _apm_route_config.apmRouter.link(apmPath, {
      path: {
        serviceName: payload.serviceName
      },
      query: {
        ...defaultQueryParams,
        ...payload.query,
        dashboardId: payload.dashboardId
      }
    });
    return path;
  } else {
    const mapObj = {
      logs: '/services/{serviceName}/logs',
      metrics: '/services/{serviceName}/metrics',
      traces: '/services/{serviceName}/transactions',
      errors: '/services/{serviceName}/errors',
      default: '/services/{serviceName}/overview'
    };
    const apmPath = mapObj[payload.serviceOverviewTab || 'default'];
    const query = {
      ...defaultQueryParams,
      ...payload.query
    };
    path = _apm_route_config.apmRouter.link(apmPath, {
      path: {
        serviceName: payload.serviceName
      },
      query
    });
  }
  return path;
}