"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceIcons = ServiceIcons;
exports.getContainerIcon = getContainerIcon;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _customIcons = require("@kbn/custom-icons");
var _react = _interopRequireWildcard(require("react"));
var _use_theme = require("../../../hooks/use_theme");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _cloud_details = require("./cloud_details");
var _serverless_details = require("./serverless_details");
var _container_details = require("./container_details");
var _otel_details = require("./otel_details");
var _icon_popover = require("./icon_popover");
var _service_details = require("./service_details");
var _serverless = require("../../../../common/serverless");
var _agent_name = require("../../../../common/agent_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getServerlessTitle(serverlessType) {
  switch (serverlessType) {
    case _serverless.ServerlessType.AWS_LAMBDA:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.aws_lambda', {
          defaultMessage: 'AWS Lambda'
        });
      }
    case _serverless.ServerlessType.AZURE_FUNCTIONS:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.azure_functions', {
          defaultMessage: 'Azure Functions'
        });
      }
    default:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.serverless', {
          defaultMessage: 'Serverless'
        });
      }
  }
}
function getContainerIcon(container) {
  if (!container) {
    return;
  }
  switch (container) {
    case 'Kubernetes':
      return 'logoKubernetes';
    default:
      return 'logoDocker';
  }
}
function ServiceIcons({
  start,
  end,
  serviceName,
  environment
}) {
  const [selectedIconPopover, setSelectedIconPopover] = (0, _react.useState)();
  const theme = (0, _use_theme.useTheme)();
  const {
    data: icons,
    status: iconsFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/metadata/icons', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [serviceName, start, end]);
  const {
    data: details,
    status: detailsFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (selectedIconPopover && serviceName && start && end && environment) {
      return callApmApi('GET /internal/apm/services/{serviceName}/metadata/details', {
        isCachable: true,
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end,
            environment
          }
        }
      });
    }
  }, [selectedIconPopover, serviceName, start, end, environment]);
  const isLoading = !icons && iconsFetchStatus === _use_fetcher.FETCH_STATUS.LOADING;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "loading"
    });
  }
  const popoverItems = [{
    key: 'service',
    icon: {
      type: (0, _customIcons.getAgentIcon)(icons === null || icons === void 0 ? void 0 : icons.agentName, theme.darkMode) || 'node'
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.agentName),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.service', {
      defaultMessage: 'Service'
    }),
    component: /*#__PURE__*/_react.default.createElement(_service_details.ServiceDetails, {
      service: details === null || details === void 0 ? void 0 : details.service
    })
  }, {
    key: 'opentelemetry',
    icon: {
      type: (0, _customIcons.getAgentIcon)('opentelemetry', theme.darkMode)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.agentName) && (0, _agent_name.isOpenTelemetryAgentName)(icons.agentName),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.opentelemetry', {
      defaultMessage: 'OpenTelemetry'
    }),
    component: /*#__PURE__*/_react.default.createElement(_otel_details.OTelDetails, {
      opentelemetry: details === null || details === void 0 ? void 0 : details.opentelemetry,
      agentName: icons === null || icons === void 0 ? void 0 : icons.agentName
    })
  }, {
    key: 'container',
    icon: {
      type: getContainerIcon(icons === null || icons === void 0 ? void 0 : icons.containerType)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.containerType),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.container', {
      defaultMessage: 'Container'
    }),
    component: /*#__PURE__*/_react.default.createElement(_container_details.ContainerDetails, {
      container: details === null || details === void 0 ? void 0 : details.container,
      kubernetes: details === null || details === void 0 ? void 0 : details.kubernetes
    })
  }, {
    key: 'serverless',
    icon: {
      type: (0, _customIcons.getServerlessIcon)(icons === null || icons === void 0 ? void 0 : icons.serverlessType) || 'node'
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.serverlessType),
    title: getServerlessTitle(icons === null || icons === void 0 ? void 0 : icons.serverlessType),
    component: /*#__PURE__*/_react.default.createElement(_serverless_details.ServerlessDetails, {
      serverless: details === null || details === void 0 ? void 0 : details.serverless
    })
  }, {
    key: 'cloud',
    icon: {
      type: (0, _customIcons.getCloudProviderIcon)(icons === null || icons === void 0 ? void 0 : icons.cloudProvider)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.cloudProvider),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.cloud', {
      defaultMessage: 'Cloud'
    }),
    component: /*#__PURE__*/_react.default.createElement(_cloud_details.CloudDetails, {
      cloud: details === null || details === void 0 ? void 0 : details.cloud,
      isServerless: !!(details !== null && details !== void 0 && details.serverless)
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, popoverItems.map(item => {
    if (item.isVisible) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        "data-test-subj": item.key,
        key: item.key
      }, /*#__PURE__*/_react.default.createElement(_icon_popover.IconPopover, {
        isOpen: selectedIconPopover === item.key,
        icon: item.icon,
        detailsFetchStatus: detailsFetchStatus,
        title: item.title,
        onClick: () => {
          setSelectedIconPopover(prevSelectedIconPopover => item.key === prevSelectedIconPopover ? null : item.key);
        },
        onClose: () => {
          setSelectedIconPopover(null);
        }
      }, item.component));
    }
  }));
}