"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentBadge = EnvironmentBadge;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _item_badge = require("../item_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EnvironmentBadge({
  environments = []
}) {
  return /*#__PURE__*/_react.default.createElement(_item_badge.ItemsBadge, {
    items: environments !== null && environments !== void 0 ? environments : [],
    multipleItemsMessage: _i18n.i18n.translate('xpack.apm.servicesTable.environmentCount', {
      values: {
        environmentCount: environments.length
      },
      defaultMessage: '{environmentCount, plural, one {1 environment} other {# environments}}'
    })
  });
}