"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmHeaderActionMenu = ApmHeaderActionMenu;
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _apm_link = require("../../../shared/links/apm/apm_link");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _alerting_popover_flyout = require("./alerting_popover_flyout");
var _anomaly_detection_setup_link = require("./anomaly_detection_setup_link");
var _inspector_header_link = require("./inspector_header_link");
var _labs = require("./labs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmHeaderActionMenu() {
  var _capabilities$ml, _capabilities$ml2;
  const {
    core,
    plugins,
    config,
    observabilityAIAssistant: {
      ObservabilityAIAssistantActionMenuItem
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    search
  } = window.location;
  const {
    application,
    http
  } = core;
  const {
    basePath
  } = http;
  const {
    capabilities
  } = application;
  const {
    featureFlags
  } = config;
  const canReadMlJobs = !!((_capabilities$ml = capabilities.ml) !== null && _capabilities$ml !== void 0 && _capabilities$ml.canGetJobs);
  const canCreateMlJobs = !!((_capabilities$ml2 = capabilities.ml) !== null && _capabilities$ml2 !== void 0 && _capabilities$ml2.canCreateJob);
  const {
    isAlertingAvailable,
    canReadAlerts,
    canSaveAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const canSaveApmAlerts = capabilities.apm.save && canSaveAlerts;
  function apmHref(path) {
    return (0, _apm_link.getLegacyApmHref)({
      basePath,
      path,
      search
    });
  }
  function kibanaHref(path) {
    return basePath.prepend(path);
  }
  const isLabsButtonEnabled = core.uiSettings.get(_common.apmLabsButton, false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, isLabsButtonEnabled && /*#__PURE__*/_react.default.createElement(_labs.Labs, null), featureFlags.storageExplorerAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "text",
    href: apmHref('/storage-explorer'),
    "data-test-subj": "apmStorageExplorerHeaderLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.storageExplorerLinkLabel', {
    defaultMessage: 'Storage Explorer'
  })))), canCreateMlJobs && /*#__PURE__*/_react.default.createElement(_anomaly_detection_setup_link.AnomalyDetectionSetupLink, null), isAlertingAvailable && /*#__PURE__*/_react.default.createElement(_alerting_popover_flyout.AlertingPopoverAndFlyout, {
    canReadAlerts: canReadAlerts,
    canSaveAlerts: canSaveApmAlerts,
    canReadMlJobs: canReadMlJobs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: kibanaHref('/app/apm/tutorial'),
    iconType: "indexOpen",
    "data-test-subj": "apmAddDataHeaderLink"
  }, _i18n.i18n.translate('xpack.apm.addDataButtonLabel', {
    defaultMessage: 'Add data'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "text",
    href: apmHref('/settings'),
    "data-test-subj": "apmSettingsHeaderLink"
  }, _i18n.i18n.translate('xpack.apm.settingsLinkLabel', {
    defaultMessage: 'Settings'
  })), /*#__PURE__*/_react.default.createElement(_inspector_header_link.InspectorHeaderLink, null), ObservabilityAIAssistantActionMenuItem ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantActionMenuItem, null) : null);
}