"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRowSetting = FormRowSetting;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FixedHeightDiv = _styledComponents.default.div`
  height: 300px;
`;
const ENABLED_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.enabledLabel', {
  defaultMessage: 'Enabled'
});
const DISABLED_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.disabledLabel', {
  defaultMessage: 'Disabled'
});
function FormRowSetting({
  row,
  value,
  onChange,
  isDisabled
}) {
  switch (row.type) {
    case 'boolean':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          label: row.placeholder || (value ? ENABLED_LABEL : DISABLED_LABEL),
          checked: value,
          onChange: e => {
            onChange(row.key, e.target.checked);
          }
        });
      }
    case 'duration':
    case 'storageSize':
    case 'text':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          prepend: isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "lock"
          }) : undefined,
          onChange: e => {
            onChange(row.key, e.target.value);
          }
        });
      }
    case 'area':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          onChange: e => {
            onChange(row.key, e.target.value);
          }
        });
      }
    case 'bytes':
    case 'integer':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          onChange: e => {
            onChange(row.key, e.target.value);
          }
        });
      }
    case 'combo':
      {
        const comboOptions = Array.isArray(value) ? value.map(label => ({
          label
        })) : [];
        return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          "data-test-subj": row.dataTestSubj,
          noSuggestions: true,
          placeholder: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.selectOrCreateOptions', {
            defaultMessage: 'Select or create options'
          }),
          options: comboOptions,
          selectedOptions: comboOptions,
          onChange: option => {
            onChange(row.key, option.map(({
              label
            }) => label));
          },
          onCreateOption: newOption => {
            onChange(row.key, [...value, newOption]);
          },
          isClearable: true
        });
      }
    case 'yaml':
      {
        return /*#__PURE__*/_react.default.createElement(FixedHeightDiv, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
          languageId: "yaml",
          width: "100%",
          height: "300px",
          value: value,
          onChange: val => {
            onChange(row.key, val);
          },
          options: {
            ariaLabel: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.yamlCodeEditor', {
              defaultMessage: 'YAML Code Editor'
            }),
            wordWrap: 'off',
            tabSize: 2,
            // To avoid left margin
            lineNumbers: 'off',
            lineNumbersMinChars: 0,
            folding: false,
            lineDecorationsWidth: 0,
            overviewRulerBorder: false
          }
        }));
      }
    default:
      throw new Error(`Unknown type "${row.type}"`);
  }
}