"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionWaterfall = AccordionWaterfall;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _lodash = require("lodash");
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../../../common/utils/formatters");
var _get_critical_path = require("../../../../../../../common/critical_path/get_critical_path");
var _use_theme = require("../../../../../../hooks/use_theme");
var _waterfall_item = require("./waterfall_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACCORDION_HEIGHT = '48px';
const StyledAccordion = (0, _common.euiStyled)(_eui.EuiAccordion).withConfig({
  shouldForwardProp: prop => !['childrenCount', 'marginLeftLevel', 'hasError'].includes(prop)
})`
  .waterfall_accordion {
    border-top: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  }

  .euiAccordion__childWrapper {
    transition: none;
  }

  ${props => {
  const borderLeft = props.hasError ? `2px solid ${props.theme.eui.euiColorDanger};` : `1px solid ${props.theme.eui.euiColorLightShade};`;
  return `.button_${props.id} {
      width: 100%;
      height: ${ACCORDION_HEIGHT};
      margin-left: ${props.marginLeftLevel}px;
      border-left: ${borderLeft}
      &:hover {
        background-color: ${props.theme.eui.euiColorLightestShade};
      }
    }`;
}}

  .accordion__buttonContent {
    width: 100%;
    height: 100%;
  }
`;
function AccordionWaterfall(props) {
  var _item$doc$event, _criticalPathSegments2;
  const {
    item,
    level,
    duration,
    waterfall,
    waterfallItemId,
    timelineMargins,
    onClickWaterfallItem,
    showCriticalPath,
    maxLevelOpen
  } = props;
  const theme = (0, _use_theme.useTheme)();
  const [isOpen, setIsOpen] = (0, _react.useState)(props.isOpen);
  let children = waterfall.childrenByParentId[item.id] || [];
  const criticalPath = showCriticalPath ? (0, _get_critical_path.getCriticalPath)(waterfall) : undefined;
  const criticalPathSegmentsById = (0, _lodash.groupBy)(criticalPath === null || criticalPath === void 0 ? void 0 : criticalPath.segments, segment => segment.item.id);
  let displayedColor = item.color;
  if (showCriticalPath) {
    children = children.filter(child => {
      var _criticalPathSegments;
      return (_criticalPathSegments = criticalPathSegmentsById[child.id]) === null || _criticalPathSegments === void 0 ? void 0 : _criticalPathSegments.length;
    });
    displayedColor = (0, _polished.transparentize)(0.5, item.color);
  }
  const errorCount = waterfall.getErrorCount(item.id);

  // To indent the items creating the parent/child tree
  const marginLeftLevel = 8 * level;
  function toggleAccordion() {
    setIsOpen(isCurrentOpen => !isCurrentOpen);
  }
  const hasToggle = !!children.length;
  return /*#__PURE__*/_react.default.createElement(StyledAccordion, {
    "data-test-subj": "waterfallItem",
    className: "waterfall_accordion",
    style: {
      position: 'relative'
    },
    buttonClassName: `button_${item.id}`,
    key: item.id,
    id: item.id,
    hasError: ((_item$doc$event = item.doc.event) === null || _item$doc$event === void 0 ? void 0 : _item$doc$event.outcome) === 'failure',
    marginLeftLevel: marginLeftLevel,
    childrenCount: children.length,
    buttonContentClassName: "accordion__buttonContent",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(ToggleAccordionButton, {
      show: hasToggle,
      isOpen: isOpen,
      childrenCount: children.length,
      onClick: toggleAccordion
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_waterfall_item.WaterfallItem, {
      key: item.id,
      timelineMargins: timelineMargins,
      color: displayedColor,
      item: item,
      hasToggle: hasToggle,
      totalDuration: duration,
      isSelected: item.id === waterfallItemId,
      errorCount: errorCount,
      marginLeftLevel: marginLeftLevel,
      onClick: flyoutDetailTab => {
        onClickWaterfallItem(item, flyoutDetailTab);
      },
      segments: (_criticalPathSegments2 = criticalPathSegmentsById[item.id]) === null || _criticalPathSegments2 === void 0 ? void 0 : _criticalPathSegments2.filter(segment => segment.self).map(segment => ({
        color: theme.eui.euiColorAccent,
        left: (segment.offset - item.offset - item.skew) / item.duration,
        width: segment.duration / item.duration
      }))
    }))),
    arrowDisplay: "none",
    initialIsOpen: true,
    forceState: isOpen ? 'open' : 'closed',
    onToggle: toggleAccordion
  }, isOpen && children.map(child => /*#__PURE__*/_react.default.createElement(AccordionWaterfall, (0, _extends2.default)({}, props, {
    key: child.id,
    isOpen: maxLevelOpen > level,
    level: level + 1,
    item: child
  }))));
}
function ToggleAccordionButton({
  show,
  isOpen,
  childrenCount,
  onClick
}) {
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: ACCORDION_HEIGHT,
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    onClick: e => {
      e.stopPropagation();
      onClick();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isOpen ? 'arrowDown' : 'arrowRight'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      top: '50%',
      transform: 'translate(0, -50%)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: childrenCount,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, (0, _formatters.asBigNumber)(childrenCount)))))));
}