"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceTemplateVariables = exports.getSelectOptions = exports.convertFiltersToQuery = exports.FILTER_SELECT_OPTIONS = exports.DEFAULT_OPTION = void 0;
var _i18n = require("@kbn/i18n");
var _mustache = _interopRequireDefault(require("mustache"));
var _lodash = require("lodash");
var _custom_link_filter_options = require("../../../../../../common/custom_link/custom_link_filter_options");
var _custom_link = require("../../../../../../common/custom_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTION = {
  value: 'DEFAULT',
  text: _i18n.i18n.translate('xpack.apm.settings.customLink.flyOut.filters.defaultOption', {
    defaultMessage: 'Select field...'
  })
};
exports.DEFAULT_OPTION = DEFAULT_OPTION;
const FILTER_SELECT_OPTIONS = [DEFAULT_OPTION, ..._custom_link_filter_options.FILTER_OPTIONS.map(filter => ({
  value: filter,
  text: filter
}))];

/**
 * Returns the options available, removing filters already added, but keeping the selected filter.
 *
 * @param filters
 * @param selectedKey
 */
exports.FILTER_SELECT_OPTIONS = FILTER_SELECT_OPTIONS;
const getSelectOptions = (filters, selectedKey) => {
  return FILTER_SELECT_OPTIONS.filter(({
    value
  }) => !filters.some(({
    key
  }) => key === value && key !== selectedKey));
};
exports.getSelectOptions = getSelectOptions;
const getInvalidTemplateVariables = (template, transaction) => {
  return _mustache.default.parse(template).filter(([type]) => type === 'name').map(([, value]) => value).filter(templateVar => (0, _lodash.get)(transaction, templateVar) == null);
};
const validateUrl = (url, transaction) => {
  if (!transaction || (0, _lodash.isEmpty)(transaction)) {
    return _i18n.i18n.translate('xpack.apm.settings.customLink.preview.transaction.notFound', {
      defaultMessage: "We couldn't find a matching transaction document based on the defined filters."
    });
  }
  try {
    const invalidVariables = getInvalidTemplateVariables(url, transaction);
    if (!(0, _lodash.isEmpty)(invalidVariables)) {
      return _i18n.i18n.translate('xpack.apm.settings.customLink.preview.contextVariable.noMatch', {
        defaultMessage: "We couldn't find a value match for {variables} in the example transaction document.",
        values: {
          variables: invalidVariables.map(variable => `{{${variable}}}`).join(', ')
        }
      });
    }
  } catch (e) {
    return _i18n.i18n.translate('xpack.apm.settings.customLink.preview.contextVariable.invalid', {
      defaultMessage: "We couldn't find an example transaction document due to invalid variable(s) defined."
    });
  }
};
const replaceTemplateVariables = (url, transaction) => ({
  formattedUrl: (0, _custom_link.getEncodedCustomLinkUrl)(url, transaction),
  error: validateUrl(url, transaction)
});
exports.replaceTemplateVariables = replaceTemplateVariables;
const convertFiltersToQuery = filters => {
  return filters.reduce((acc, {
    key,
    value
  }) => {
    if (key && value) {
      acc[key] = value;
    }
    return acc;
  }, {});
};
exports.convertFiltersToQuery = convertFiltersToQuery;