"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetection = AnomalyDetection;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _anomaly_detection = require("../../../../../common/anomaly_detection");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jobs_list = require("./jobs_list");
var _add_environments = require("./add_environments");
var _license_prompt = require("../../../shared/license_prompt");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_anomaly_detection_jobs_context = require("../../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnomalyDetection() {
  var _plugin$core$applicat;
  const plugin = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canGetJobs = !!((_plugin$core$applicat = plugin.core.application.capabilities.ml) !== null && _plugin$core$applicat !== void 0 && _plugin$core$applicat.canGetJobs);
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('platinum'));
  const [viewAddEnvironments, setViewAddEnvironments] = (0, _react.useState)(false);
  const {
    anomalyDetectionJobsStatus,
    anomalyDetectionJobsRefetch,
    anomalyDetectionJobsData = {
      jobs: [],
      hasLegacyJobs: false
    },
    anomalyDetectionSetupState
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  if (!hasValidLicense) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      text: _anomaly_detection.ML_ERRORS.INVALID_LICENSE
    }));
  }
  if (!canGetJobs) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _anomaly_detection.ML_ERRORS.MISSING_READ_PRIVILEGES)
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewAddEnvironments ? /*#__PURE__*/_react.default.createElement(_add_environments.AddEnvironments, {
    currentEnvironments: anomalyDetectionJobsData.jobs.map(({
      environment
    }) => environment),
    onCreateJobSuccess: () => {
      anomalyDetectionJobsRefetch();
      setViewAddEnvironments(false);
    },
    onCancel: () => {
      setViewAddEnvironments(false);
    }
  }) : /*#__PURE__*/_react.default.createElement(_jobs_list.JobsList, {
    data: anomalyDetectionJobsData,
    status: anomalyDetectionJobsStatus,
    setupState: anomalyDetectionSetupState,
    onAddEnvironments: () => {
      setViewAddEnvironments(true);
    },
    onUpdateComplete: () => {
      anomalyDetectionJobsRefetch();
    }
  }));
}