"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_SIZE = void 0;
exports.ServiceOverviewInstancesChartAndTable = ServiceOverviewInstancesChartAndTable;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _get_comparison_options = require("../../shared/time_comparison/get_comparison_options");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _instances_latency_distribution_chart = require("../../shared/charts/instances_latency_distribution_chart");
var _service_overview_instances_table = require("./service_overview_instances_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE_MAIN_STATS = {
  currentPeriodItems: [],
  previousPeriodItems: [],
  requestId: undefined,
  currentPeriodItemsCount: 0
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
const PAGE_SIZE = 5;
exports.PAGE_SIZE = PAGE_SIZE;
const DEFAULT_SORT = {
  direction: 'desc',
  field: 'throughput'
};
function ServiceOverviewInstancesChartAndTable({
  chartHeight,
  serviceName
}) {
  const {
    transactionType,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const [tableOptions, setTableOptions] = (0, _react.useState)({
    pageIndex: 0,
    sort: DEFAULT_SORT
  });
  const {
    pageIndex,
    sort
  } = tableOptions;
  const {
    direction,
    field
  } = sort;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      comparisonEnabled,
      offset,
      latencyAggregationType
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: mainStatsData = INITIAL_STATE_MAIN_STATS,
    status: mainStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve(INITIAL_STATE_MAIN_STATS);
    }
    if (!start || !end || !transactionType || !latencyAggregationType) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/service_overview_instances/main_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          latencyAggregationType: latencyAggregationType,
          start,
          end,
          transactionType,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
        }
      }
    }).then(response => {
      var _response$currentPeri;
      return {
        // Everytime the main statistics is refetched, updates the requestId making the detailed API to be refetched.
        requestId: (0, _uuid.v4)(),
        currentPeriodItems: (_response$currentPeri = response === null || response === void 0 ? void 0 : response.currentPeriod) !== null && _response$currentPeri !== void 0 ? _response$currentPeri : [],
        currentPeriodItemsCount: response === null || response === void 0 ? void 0 : response.currentPeriod.length,
        previousPeriodItems: response === null || response === void 0 ? void 0 : response.previousPeriod
      };
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, latencyAggregationType, start, end, serviceName, transactionType, transactionTypeStatus, pageIndex, field, direction,
  // not used, but needed to trigger an update when offset is changed either manually by user or when time range is changed
  offset,
  // not used, but needed to trigger an update when comparison feature is disabled/enabled by user
  comparisonEnabled]);
  const {
    currentPeriodItems,
    previousPeriodItems,
    requestId,
    currentPeriodItemsCount
  } = mainStatsData;
  const currentPeriodOrderedItems = (0, _lodash.orderBy)(
  // need top-level sortable fields for the managed table
  currentPeriodItems.map(item => {
    var _item$latency, _item$throughput, _item$errorRate, _item$cpuUsage, _item$memoryUsage;
    return {
      ...item,
      latency: (_item$latency = item.latency) !== null && _item$latency !== void 0 ? _item$latency : 0,
      throughput: (_item$throughput = item.throughput) !== null && _item$throughput !== void 0 ? _item$throughput : 0,
      errorRate: (_item$errorRate = item.errorRate) !== null && _item$errorRate !== void 0 ? _item$errorRate : 0,
      cpuUsage: (_item$cpuUsage = item.cpuUsage) !== null && _item$cpuUsage !== void 0 ? _item$cpuUsage : 0,
      memoryUsage: (_item$memoryUsage = item.memoryUsage) !== null && _item$memoryUsage !== void 0 ? _item$memoryUsage : 0
    };
  }), field, direction).slice(pageIndex * PAGE_SIZE, (pageIndex + 1) * PAGE_SIZE);
  const {
    data: detailedStatsData = INITIAL_STATE_DETAILED_STATISTICS,
    status: detailedStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end || !transactionType || !latencyAggregationType || !currentPeriodItemsCount) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/service_overview_instances/detailed_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          latencyAggregationType: latencyAggregationType,
          start,
          end,
          numBuckets: 20,
          transactionType,
          serviceNodeIds: JSON.stringify(currentPeriodOrderedItems.map(item => item.serviceNodeName)),
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
        }
      }
    });
  },
  // only fetches detailed statistics when requestId is invalidated by main statistics api call
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_instances_latency_distribution_chart.InstancesLatencyDistributionChart, {
    height: chartHeight,
    items: currentPeriodItems,
    status: mainStatsStatus,
    comparisonItems: previousPeriodItems
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_service_overview_instances_table.ServiceOverviewInstancesTable, {
    mainStatsItems: currentPeriodOrderedItems,
    mainStatsStatus: mainStatsStatus,
    mainStatsItemCount: currentPeriodItemsCount,
    detailedStatsLoading: (0, _use_fetcher.isPending)(detailedStatsStatus),
    detailedStatsData: detailedStatsData,
    serviceName: serviceName,
    tableOptions: tableOptions,
    isLoading: mainStatsStatus === _use_fetcher.FETCH_STATUS.LOADING,
    isNotInitiated: mainStatsStatus === _use_fetcher.FETCH_STATUS.NOT_INITIATED,
    onChangeTableOptions: newTableOptions => {
      var _newTableOptions$page, _newTableOptions$page2;
      setTableOptions({
        pageIndex: (_newTableOptions$page = (_newTableOptions$page2 = newTableOptions.page) === null || _newTableOptions$page2 === void 0 ? void 0 : _newTableOptions$page2.index) !== null && _newTableOptions$page !== void 0 ? _newTableOptions$page : 0,
        sort: newTableOptions.sort ? {
          field: newTableOptions.sort.field,
          direction: newTableOptions.sort.direction
        } : DEFAULT_SORT
      });
    }
  }))));
}