"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingFlamegraph = ProfilingFlamegraph;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../common/es_fields/apm");
var _kuery_utils = require("../../../../common/utils/kuery_utils");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_profiling_plugin = require("../../../hooks/use_profiling_plugin");
var _host_names_filter_warning = require("./host_names_filter_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingFlamegraph({
  start,
  end,
  serviceName,
  environment,
  dataSource,
  kuery,
  rangeFrom,
  rangeTo
}) {
  const {
    profilingLocators
  } = (0, _use_profiling_plugin.useProfilingPlugin)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (dataSource) {
      return callApmApi('GET /internal/apm/services/{serviceName}/profiling/flamegraph', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end,
            environment,
            documentType: dataSource.documentType,
            rollupInterval: dataSource.rollupInterval,
            kuery
          }
        }
      });
    }
  }, [dataSource, serviceName, start, end, environment, kuery]);
  const hostNamesKueryFormat = (0, _kuery_utils.toKueryFilterFormat)(_apm.HOST_NAME, (data === null || data === void 0 ? void 0 : data.hostNames) || []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_host_names_filter_warning.HostnamesFilterWarning, {
    hostNames: data === null || data === void 0 ? void 0 : data.hostNames
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      justifyContent: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmProfilingFlamegraphGoToFlamegraphLink",
    href: profilingLocators === null || profilingLocators === void 0 ? void 0 : profilingLocators.flamegraphLocator.getRedirectUrl({
      kuery: (0, _kuery_utils.mergeKueries)([`(${hostNamesKueryFormat})`, kuery]),
      rangeFrom,
      rangeTo
    })
  }, _i18n.i18n.translate('xpack.apm.profiling.flamegraph.link', {
    defaultMessage: 'Go to Universal Profiling Flamegraph'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), status === _use_fetcher.FETCH_STATUS.SUCCESS && (0, _lodash.isEmpty)(data) ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.apm.profiling.flamegraph.noDataFound', {
      defaultMessage: 'No data found'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_public.EmbeddableFlamegraph, {
    data: data === null || data === void 0 ? void 0 : data.flamegraph,
    isLoading: (0, _use_fetcher.isPending)(status),
    height: "60vh"
  }));
}