"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailurePrompt = FailurePrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FailurePrompt() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    iconType: "warning",
    layout: "vertical",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.infraTabs.failurePromptTitle', {
      defaultMessage: 'Unable to load your infrastructure data'
    })),
    titleSize: "m",
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.infraTabs.failurePromptDescription', {
      defaultMessage: 'There was a problem loading the Infrastructure tab and your data. You can contact your administrator for help.'
    }))
  });
}