"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsImportExport = DiagnosticsImportExport;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_diagnostics = require("./context/use_diagnostics");
var _index_templates_status = require("./summary_tab/index_templates_status");
var _indicies_status = require("./summary_tab/indicies_status");
var _data_streams_status = require("./summary_tab/data_streams_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsImportExport() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExportCard, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ImportCard, null)));
}
function ExportCard() {
  const {
    diagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    isDisabled: isImported,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "importAction"
    }),
    title: "Export",
    description: "Export the diagnostics report in order to provide it to Elastic Support",
    footer: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isImported,
      "data-test-subj": "apmDiagnosticsImportExportGoForItButton",
      "aria-label": "Export diagnostics report",
      onClick: () => {
        if (!diagnosticsBundle) {
          return;
        }
        const blob = new Blob([JSON.stringify(diagnosticsBundle, null, 2)], {
          type: 'text/plain'
        });
        const fileURL = URL.createObjectURL(blob);
        const {
          kibanaVersion
        } = diagnosticsBundle;
        const link = document.createElement('a');
        link.href = fileURL;
        link.download = `apm-diagnostics-${kibanaVersion}-${Date.now()}.json`;
        link.click();
      }
    }, "Export"))
  });
}
function ImportCard() {
  const {
    setImportedDiagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const [importStatus, setImportStatus] = (0, _react.useState)({
    isValid: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "exportAction"
    }),
    title: "Import diagnostics report",
    description: isImported ? 'Diagnostics report was imported' : `Import a diagnostics report in order to view the results in the UI`,
    footer: /*#__PURE__*/_react.default.createElement("div", null, isImported ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmImportCardRemoveReportButton",
      onClick: () => setImportedDiagnosticsBundle(undefined),
      color: "danger"
    }, "Remove report") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !importStatus.isValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning"
    }, "The uploaded file could not be parsed:", ' ', importStatus.errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      fullWidth: true,
      id: "file-picker",
      multiple: true,
      onChange: _files => {
        setImportStatus({
          isValid: true
        });
        if (_files && _files.length > 0) {
          const file = Array.from(_files)[0];
          const reader = new FileReader();
          reader.onload = evt => {
            try {
              var _evt$target;
              const diagnosticsBundle = JSON.parse( // @ts-expect-error
              evt === null || evt === void 0 ? void 0 : (_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : _evt$target.result);
              validateBundle(diagnosticsBundle);
              setImportedDiagnosticsBundle(diagnosticsBundle);
            } catch (e) {
              setImportStatus({
                isValid: false,
                errorMessage: e.message
              });
              console.error(`Could not parse file ${file.name}. ${e.message}`);
            }
          };
          reader.readAsText(file);
        }
      }
    })))
  });
}
function validateBundle(diagnosticsBundle) {
  try {
    (0, _index_templates_status.getIsIndexTemplateOk)(diagnosticsBundle);
    (0, _indicies_status.getIsIndicesTabOk)(diagnosticsBundle);
    (0, _data_streams_status.getIsDataStreamTabOk)(diagnosticsBundle);
  } catch (e) {
    console.error('Error parsing uploaded bundle', e);
    throw e;
  }
}