"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsContext = void 0;
exports.DiagnosticsContextProvider = DiagnosticsContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_fetcher = require("../../../../hooks/use_fetcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DiagnosticsContext = /*#__PURE__*/_react.default.createContext({
  diagnosticsBundle: undefined,
  setImportedDiagnosticsBundle: () => undefined,
  status: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  refetch: () => undefined
});
exports.DiagnosticsContext = DiagnosticsContext;
function DiagnosticsContextProvider({
  children
}) {
  const {
    query: {
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/diagnostics/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo,
    optional: true
  });
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi(`GET /internal/apm/diagnostics`, {
      isCachable: false,
      params: {
        query: {
          start,
          end,
          kuery
        }
      }
    });
  }, [start, end, kuery]);
  const [importedDiagnosticsBundle, setImportedDiagnosticsBundle] = (0, _react.useState)(undefined);
  const value = (0, _react.useMemo)(() => {
    if (importedDiagnosticsBundle) {
      return {
        refetch,
        diagnosticsBundle: importedDiagnosticsBundle,
        setImportedDiagnosticsBundle,
        status: _use_fetcher.FETCH_STATUS.SUCCESS,
        isImported: true
      };
    }
    return {
      refetch,
      diagnosticsBundle: data,
      setImportedDiagnosticsBundle,
      status,
      isImported: false
    };
  }, [importedDiagnosticsBundle, setImportedDiagnosticsBundle, status, data, refetch]);
  return /*#__PURE__*/_react.default.createElement(DiagnosticsContext.Provider, {
    value: value,
    children: children
  });
}