"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatencyCorrelationsHelpPopover = LatencyCorrelationsHelpPopover;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _help_popover = require("../help_popover/help_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LatencyCorrelationsHelpPopover() {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
    anchorPosition: "leftUp",
    button: /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopoverButton, {
      buttonTextEnabled: true,
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      }
    }),
    closePopover: () => setIsPopoverOpen(false),
    isOpen: isPopoverOpen,
    title: _i18n.i18n.translate('xpack.apm.correlations.latencyPopoverTitle', {
      defaultMessage: 'Latency correlations'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyPopoverBasicExplanation",
    defaultMessage: "Correlations help you discover which attributes are contributing to increased transaction response times or latency."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyPopoverChartExplanation",
    defaultMessage: "The latency distribution chart visualizes the overall latency of the transactions in the transaction group. When you hover over attributes in the table, their latency distribution is added to the chart."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyPopoverTableExplanation",
    defaultMessage: "The table is sorted by correlation coefficients that range from 0 to 1. Attributes with higher correlation values are more likely to contribute to high latency transactions."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyPopoverPerformanceExplanation",
    defaultMessage: "This analysis performs statistical searches across a large number of attributes. For large time ranges and services with high transaction throughput, this might take some time. Reduce the time range to improve performance."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyPopoverFilterExplanation",
    defaultMessage: "You can also add or remove filters to affect the queries in the APM app."
  })));
}