"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTemplateVariableNames = exports.NO_PERMISSION_LABEL = exports.INVALID_LICENSE = void 0;
exports.getEncodedCustomLinkUrl = getEncodedCustomLinkUrl;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _mustache = _interopRequireDefault(require("mustache"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_LICENSE = _i18n.i18n.translate('xpack.apm.settings.customLink.license.text', {
  defaultMessage: "To create custom links, you must be subscribed to an Elastic Gold license or above. With it, you'll have the ability to create custom links to improve your workflow when analyzing your services."
});
exports.INVALID_LICENSE = INVALID_LICENSE;
const NO_PERMISSION_LABEL = _i18n.i18n.translate('xpack.apm.settings.customLink.noPermissionTooltipLabel', {
  defaultMessage: "Your user role doesn't have permissions to create custom links"
});
exports.NO_PERMISSION_LABEL = NO_PERMISSION_LABEL;
const extractTemplateVariableNames = url => {
  const uniqueVariableNames = new Set();
  _mustache.default.parse(url).filter(v => v[0] === 'name').map(v => uniqueVariableNames.add(v[1]));
  return Array.from(uniqueVariableNames);
};
exports.extractTemplateVariableNames = extractTemplateVariableNames;
function getEncodedCustomLinkUrl(url, transaction) {
  try {
    const templateVariables = extractTemplateVariableNames(url);
    const encodedTemplateVariables = {};
    templateVariables.forEach(name => {
      const value = (0, _lodash.get)(transaction, name);
      if (value) {
        const encodedValue = encodeURIComponent(value);
        (0, _saferLodashSet.set)(encodedTemplateVariables, name, encodedValue);
      }
    });
    return _mustache.default.render(url, encodedTemplateVariables);
  } catch (e) {
    return url;
  }
}