"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addGeneratedActionValues = addGeneratedActionValues;
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function addGeneratedActionValues(actions = []) {
  return actions.map(({
    uuid,
    alertsFilter,
    ...action
  }) => {
    const generateDSL = (kql, filters) => {
      try {
        return JSON.stringify((0, _esQuery.buildEsQuery)(undefined, [{
          query: kql,
          language: 'kuery'
        }], filters));
      } catch (e) {
        throw _boom.default.badRequest(`Error creating DSL query: invalid KQL`);
      }
    };
    return {
      ...action,
      uuid: uuid || (0, _uuid.v4)(),
      ...(alertsFilter ? {
        alertsFilter: {
          ...alertsFilter,
          query: alertsFilter.query ? {
            ...alertsFilter.query,
            dsl: generateDSL(alertsFilter.query.kql, alertsFilter.query.filters)
          } : undefined
        }
      } : {})
    };
  });
}