"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */
const stateSchemaByVersion = {
  1: {
    up: state => ({
      runs: state.runs || 0,
      total_invalidated: state.total_invalidated || 0
    }),
    schema: _configSchema.schema.object({
      runs: _configSchema.schema.number(),
      total_invalidated: _configSchema.schema.number()
    })
  }
};
exports.stateSchemaByVersion = stateSchemaByVersion;
const latestTaskStateSchema = stateSchemaByVersion[1].schema;
const emptyState = {
  runs: 0,
  total_invalidated: 0
};
exports.emptyState = emptyState;