"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AlertingAuthorization", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorization;
  }
});
Object.defineProperty(exports, "AlertingAuthorizationEntity", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorizationEntity;
  }
});
Object.defineProperty(exports, "AlertingAuthorizationFilterType", {
  enumerable: true,
  get: function () {
    return _authorization.AlertingAuthorizationFilterType;
  }
});
Object.defineProperty(exports, "DEFAULT_ALERTS_ILM_POLICY", {
  enumerable: true,
  get: function () {
    return _alerts_service.DEFAULT_ALERTS_ILM_POLICY;
  }
});
Object.defineProperty(exports, "DEFAULT_ALERTS_ILM_POLICY_NAME", {
  enumerable: true,
  get: function () {
    return _alerts_service.DEFAULT_ALERTS_ILM_POLICY_NAME;
  }
});
Object.defineProperty(exports, "DEFAULT_MAX_EPHEMERAL_ACTIONS_PER_ALERT", {
  enumerable: true,
  get: function () {
    return _config.DEFAULT_MAX_EPHEMERAL_ACTIONS_PER_ALERT;
  }
});
Object.defineProperty(exports, "ECS_COMPONENT_TEMPLATE_NAME", {
  enumerable: true,
  get: function () {
    return _alerts_service.ECS_COMPONENT_TEMPLATE_NAME;
  }
});
Object.defineProperty(exports, "ECS_CONTEXT", {
  enumerable: true,
  get: function () {
    return _alerts_service.ECS_CONTEXT;
  }
});
Object.defineProperty(exports, "InstallShutdownError", {
  enumerable: true,
  get: function () {
    return _alerts_service.InstallShutdownError;
  }
});
Object.defineProperty(exports, "ReadOperations", {
  enumerable: true,
  get: function () {
    return _authorization.ReadOperations;
  }
});
Object.defineProperty(exports, "RuleNotifyWhen", {
  enumerable: true,
  get: function () {
    return _common.RuleNotifyWhen;
  }
});
Object.defineProperty(exports, "TOTAL_FIELDS_LIMIT", {
  enumerable: true,
  get: function () {
    return _alerts_service.TOTAL_FIELDS_LIMIT;
  }
});
Object.defineProperty(exports, "VALID_ALERT_INDEX_PREFIXES", {
  enumerable: true,
  get: function () {
    return _alerts_service.VALID_ALERT_INDEX_PREFIXES;
  }
});
Object.defineProperty(exports, "WriteOperations", {
  enumerable: true,
  get: function () {
    return _authorization.WriteOperations;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createConcreteWriteIndex", {
  enumerable: true,
  get: function () {
    return _alerts_service.createConcreteWriteIndex;
  }
});
Object.defineProperty(exports, "createOrUpdateComponentTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateComponentTemplate;
  }
});
Object.defineProperty(exports, "createOrUpdateIlmPolicy", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateIlmPolicy;
  }
});
Object.defineProperty(exports, "createOrUpdateIndexTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.createOrUpdateIndexTemplate;
  }
});
Object.defineProperty(exports, "getComponentTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.getComponentTemplate;
  }
});
Object.defineProperty(exports, "getDataStreamAdapter", {
  enumerable: true,
  get: function () {
    return _data_stream_adapter.getDataStreamAdapter;
  }
});
Object.defineProperty(exports, "getEsErrorMessage", {
  enumerable: true,
  get: function () {
    return _errors.getEsErrorMessage;
  }
});
Object.defineProperty(exports, "getIndexTemplate", {
  enumerable: true,
  get: function () {
    return _alerts_service.getIndexTemplate;
  }
});
Object.defineProperty(exports, "installWithTimeout", {
  enumerable: true,
  get: function () {
    return _alerts_service.installWithTimeout;
  }
});
Object.defineProperty(exports, "isRuleSnoozed", {
  enumerable: true,
  get: function () {
    return _lib.isRuleSnoozed;
  }
});
Object.defineProperty(exports, "isValidAlertIndexName", {
  enumerable: true,
  get: function () {
    return _alerts_service.isValidAlertIndexName;
  }
});
Object.defineProperty(exports, "parseDuration", {
  enumerable: true,
  get: function () {
    return _lib.parseDuration;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "sanitizeBulkErrorResponse", {
  enumerable: true,
  get: function () {
    return _alerts_client.sanitizeBulkErrorResponse;
  }
});
var _config = require("./config");
var _common = require("../common");
var _lib = require("./lib");
var _errors = require("./lib/errors");
var _authorization = require("./authorization");
var _alerts_service = require("./alerts_service");
var _alerts_client = require("./alerts_client");
var _data_stream_adapter = require("./alerts_service/lib/data_stream_adapter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const plugin = async initContext => {
  const {
    AlertingPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new AlertingPlugin(initContext);
};
exports.plugin = plugin;
const config = {
  schema: _config.configSchema,
  deprecations: ({
    renameFromRoot,
    deprecate
  }) => [renameFromRoot('xpack.alerts.healthCheck', 'xpack.alerting.healthCheck', {
    level: 'warning'
  }), renameFromRoot('xpack.alerts.invalidateApiKeysTask.interval', 'xpack.alerting.invalidateApiKeysTask.interval', {
    level: 'warning'
  }), renameFromRoot('xpack.alerts.invalidateApiKeysTask.removalDelay', 'xpack.alerting.invalidateApiKeysTask.removalDelay', {
    level: 'warning'
  }), renameFromRoot('xpack.alerting.defaultRuleTaskTimeout', 'xpack.alerting.rules.run.timeout', {
    level: 'warning'
  }), deprecate('maxEphemeralActionsPerAlert', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.alerting.maxEphemeralActionsPerAlert" is deprecated and will be removed in a future version. Remove this setting to increase action execution resiliency.`
  })]
};
exports.config = config;