"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeRule = snoozeRule;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _apmUtils = require("@kbn/apm-utils");
var _lib = require("../../../../rules_client/lib");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _authorization = require("../../../../authorization");
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _validate_snooze_date = require("../../../../lib/validate_snooze_date");
var _rule_muted = require("../../../../lib/errors/rule_muted");
var _common = require("../../../../rules_client/common");
var _rule = require("../../../../data/rule");
var _update_meta_attributes = require("../../../../rules_client/lib/update_meta_attributes");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function snoozeRule(context, {
  id,
  snoozeSchedule
}) {
  try {
    _schemas.snoozeRuleParamsSchema.validate({
      id
    });
  } catch (error) {
    throw _boom.default.badRequest(`Error validating snooze params - ${error.message}`);
  }
  const snoozeDateValidationMsg = (0, _validate_snooze_date.validateSnoozeStartDate)(snoozeSchedule.rRule.dtstart);
  if (snoozeDateValidationMsg) {
    throw new _rule_muted.RuleMutedError(snoozeDateValidationMsg);
  }
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.snooze('${id}', ${JSON.stringify(snoozeSchedule, null, 4)})`, async () => await snoozeWithOCC(context, {
    id,
    snoozeSchedule
  }));
}
async function snoozeWithOCC(context, {
  id,
  snoozeSchedule
}) {
  var _context$auditLogger2;
  const {
    attributes,
    version
  } = await (0, _apmUtils.withSpan)({
    name: 'getRuleSavedObject',
    type: 'rules'
  }, () => (0, _lib.getRuleSavedObject)(context, {
    ruleId: id
  }));
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.Snooze,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized({
        operation: 'execute'
      });
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.SNOOZE,
      savedObject: {
        type: 'alert',
        id
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.SNOOZE,
    outcome: 'unknown',
    savedObject: {
      type: 'alert',
      id
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);
  const newAttrs = (0, _common.getSnoozeAttributes)(attributes, snoozeSchedule);
  try {
    (0, _common.verifySnoozeAttributeScheduleLimit)(newAttrs);
  } catch (error) {
    throw _boom.default.badRequest(error.message);
  }
  await (0, _rule.updateRuleSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    savedObjectsUpdateOptions: {
      version
    },
    id,
    updateRuleAttributes: (0, _update_meta_attributes.updateMetaAttributes)(context, {
      ...newAttrs,
      updatedBy: await context.getUserName(),
      updatedAt: new Date().toISOString()
    })
  });
}