"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateOptionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggregateOptionsSchema = _configSchema.schema.object({
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  defaultSearchOperator: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('AND'), _configSchema.schema.literal('OR')])),
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  hasReference: _configSchema.schema.maybe(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  })),
  filterConsumers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  // filter type is `string | KueryNode`, but `KueryNode` has no schema to import yet
  filter: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())])),
  page: _configSchema.schema.maybe(_configSchema.schema.number()),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.aggregateOptionsSchema = aggregateOptionsSchema;