"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string(),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6)])),
  until: _configSchema.schema.maybe(_configSchema.schema.string()),
  count: _configSchema.schema.maybe(_configSchema.schema.number()),
  interval: _configSchema.schema.maybe(_configSchema.schema.number()),
  wkst: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('MO'), _configSchema.schema.literal('TU'), _configSchema.schema.literal('WE'), _configSchema.schema.literal('TH'), _configSchema.schema.literal('FR'), _configSchema.schema.literal('SA'), _configSchema.schema.literal('SU')])),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  bysetpos: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  byyearday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  byweekno: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  byhour: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  byminute: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  bysecond: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number()))
});
exports.rRuleSchema = rRuleSchema;