"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMaintenanceWindowParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schemas = require("../../../schemas");
var _schemas2 = require("../../../../r_rule/schemas");
var _schemas3 = require("../../../../alerts_filter_query/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateMaintenanceWindowParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  data: _configSchema.schema.object({
    title: _configSchema.schema.maybe(_configSchema.schema.string()),
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    duration: _configSchema.schema.maybe(_configSchema.schema.number()),
    rRule: _configSchema.schema.maybe(_schemas2.rRuleRequestSchema),
    categoryIds: _schemas.maintenanceWindowCategoryIdsSchema,
    scopedQuery: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas3.alertsFilterQuerySchema))
  })
});
exports.updateMaintenanceWindowParamsSchema = updateMaintenanceWindowParamsSchema;