"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUpdatedRecoveredAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _format_alert = require("./format_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates an existing recovered alert document with latest flapping
 * information
 */

const buildUpdatedRecoveredAlert = ({
  alert,
  legacyRawAlert,
  rule,
  timestamp
}) => {
  var _legacyRawAlert$meta, _legacyRawAlert$meta2;
  // Make sure that any alert fields that are updateable are flattened.
  const refreshableAlertFields = (0, _format_alert.replaceRefreshableAlertFields)(alert);
  const alertUpdates = {
    // Set latest rule configuration
    ...rule,
    // Update the timestamp to reflect latest update time
    [_ruleDataUtils.TIMESTAMP]: timestamp,
    // Set latest flapping state
    [_ruleDataUtils.ALERT_FLAPPING]: (_legacyRawAlert$meta = legacyRawAlert.meta) === null || _legacyRawAlert$meta === void 0 ? void 0 : _legacyRawAlert$meta.flapping,
    // Set latest flapping history
    [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: (_legacyRawAlert$meta2 = legacyRawAlert.meta) === null || _legacyRawAlert$meta2 === void 0 ? void 0 : _legacyRawAlert$meta2.flappingHistory
  };

  // Clean the existing alert document so any nested fields that will be updated
  // are removed, to avoid duplicate data.
  // e.g. if the existing alert document has the field:
  // {
  //   kibana: {
  //     alert: {
  //       field1: 'value1'
  //     }
  //   }
  // }
  // and the updated alert has the field
  // {
  //   'kibana.alert.field1': 'value2'
  // }
  // the expanded field from the existing alert is removed
  const cleanedAlert = (0, _format_alert.removeUnflattenedFieldsFromAlert)(alert, {
    ...alertUpdates,
    ...refreshableAlertFields
  });
  return _deepmerge.default.all([cleanedAlert, refreshableAlertFields, alertUpdates], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildUpdatedRecoveredAlert = buildUpdatedRecoveredAlert;